define([
    'backbone',
    'modules/new-appointment-request/views/common/error/view',
    'modules/new-appointment-request/tests/helpers/general-helper',
], function(Backbone, ErrorView, helpers) {
    'use strict';

    describe('Scheduling Form Error View', function() {
        var region;

        beforeEach(function() {
            region = helpers.setupTestingRegion();
        });

        it('draw the view with a simple error collection', function() {
            var data = [
                {error: 'one'},
                {error: 'two'},
            ];
            var collection = new Backbone.Collection(data);
            var li;

            region.show(new ErrorView({collection: collection}));
            li = region.currentView.$('li');

            expect(li[0].innerText).toBe(data[0].error);
            expect(li[1].innerText).toBe(data[1].error);
        });

        it('draw the view with a non-formatted resource error collection', function() {
            var data = [
                {
                    fieldName: 'a',
                    errorMessage: 'error 1',
                },
                {
                    fieldName: 'b',
                    errorMessage: 'error 2',
                },
            ];
            var collection = new Backbone.Collection(data);
            var li;
            region.show(new ErrorView({collection: collection}));
            li = region.currentView.$('li');

            expect(li[0].innerText).toBe(data[0].errorMessage);
            expect(li[1].innerText).toBe(data[1].errorMessage);
        });

        it('draw the view with a formatted resource error collection', function() {
            var data = [
                {
                    fieldName: 'optionDate1',
                    errorMessage: 'error 1',
                },
                {
                    fieldName: 'optionDate2',
                    errorMessage: 'error 2',
                },
            ];
            var collection = new Backbone.Collection(data);
            var li;

            region.show(new ErrorView({collection: collection}));
            li = region.currentView.$('li');

            expect(li[0].innerText).toBe('Choice #1 Date: ' + data[0].errorMessage);
            expect(li[1].innerText).toBe('Choice #2 Date: ' + data[1].errorMessage);
        });

        it('defaults error message if it can not format', function() {
            var data = [{a: 'default message'}];
            var collection = new Backbone.Collection(data);
            var li;

            region.show(new ErrorView({collection: collection}));
            li = region.currentView.$('li');

            expect(li[0].innerText).toBe('An error has occurred');
        });
    });
});
